% ex6_5ukf.m
% section 6.5
% estimation of Wiener model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% x(t+1) = A*x(t)+B*u(t)+w(t)
%   y(t) = beta1*x(t)+beta2*x(t)^2+beta3*x(t)^3+v(t)
% clear;
clear

r=0.25;            % covariance of observation noise
q=0.36;            % covariance of system noise
N=1000;
a=0.9;
b=1;
n=4;
beta1=1;
beta2=0.05;
beta3=-0.01;
q=0.36;
r=0.25;
t=0:1:N;
x=zeros(4,N+1);
v=sqrt(r)*randn(1,N+1);
w=sqrt(q)*randn(1,N+1);
y=zeros(1,N+1);
u=2.0*randn(1,N+1);
x(1,1)=0;
x(2,1)=beta1;
x(3,1)=beta2;
x(4,1)=beta3;
% data generation
for i=1:N
x(1,i+1)= a*x(1,i) + b*u(1,i)+w(1,i);
x(2,i+1)=beta1;
x(3,i+1)=beta2;
x(4,i+1)=beta3;
z=x(1,i);
tau= (beta1 + (beta2+beta3*z)*z)*z;
y(1,i)=tau + v(1,i);
end
z=x(1,N+1);
tau= (beta1 + (beta2+beta3*z)*z)*z;
y(1,N+1)=x(1,N+1)+v(1,N+1);
%------------------------------------------------
lam=2.0;          % UT parameter
nn=2*n+1;         % total number of sigma points
nl=n+lam;
xs=zeros(n,nn);   % initializing of sigma points
xst=zeros(n,nn);  %
% UKF
P0=eye(n,n);
P0(1,1)=4; 
Pep=P0;
x0=[0 0 0 0]';
xep=x0;
QQ=zeros(n,n);
QQ(1,1)=q;
% sigma points
[U,S,V]=svd(Pep);
SP=U*sqrt(S);
for j=1:n
xst(:,j)=xep + sqrt(nl)*SP(:,j);
xst(:,j+n)=xep - sqrt(nl)*SP(:,j);
ws(j)=0.5/nl;
ws(j+n)=ws(j);
end
xst(:,nn)=xep;
ws(nn)= lam/nl;
%
for i=1:N+1
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Input: (xst(j),Pep,yt) --> Output (xef,Pef)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% nonlinear transformation of sigma points 
for j=1:nn
yst(1,j)=xst(2,j)*xst(1,j)+ ...
    xst(3,j)*xst(1,j)*xst(1,j)+...
    xst(4,j)*xst(1,j)*xst(1,j)*xst(1,j);
end
% mean and covariance of output y
ys=zeros(1,1);
for j=1:nn
    ys=ys+ws(j)*yst(1,j);
end
Pnu=zeros(1,1);
for j=1:nn
    Pnu=Pnu+ws(j)*(yst(1,j)-ys)*(yst(1,j)-ys)';
end
Pnu=Pnu+r; % covariance of innovation
%
Pxnu=zeros(n,1); % cross-covariance of x and nu
for j=1:nn
Pxnu=Pxnu+ws(j)*(xst(:,j)-xep)*(yst(1,j)-ys)';
end

Kt=Pxnu*inv(Pnu);           % UKF Kalman gain 
xef=xep+Kt*(y(1,i)-ys);     % filtered estimate      
Pef=Pep-Kt*Pnu*Kt';         % filtered covariance matrix
%
xeff(:,i)=xef;                % for figure
Peff(:,:,i)=Pef;              %
Kff(:,i)=Kt;                  %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Input: (xef, Pef) --> Output (xep, Pep)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% sigma points
[U,S,V]=svd(Pef);
SP=U*sqrt(S);
for j=1:n
xs(:,j)=xef + sqrt(nl)*SP(:,j);
xs(:,j+n)=xef - sqrt(nl)*SP(:,j);
end
xs(:,nn)=xef;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% transformation of sigma points; this step can be 
% replaced by the algorithm of standard Kalman filter
% since f is linear (see p. 116)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
for j=1:nn
xst(1,j)=a*xs(1,j)+b*u(1,i);
xst(2,j)=xs(2,j);
xst(3,j)=xs(3,j);
xst(4,j)=xs(4,j);
end
% prediction
xt=zeros(n,1);
for j=1:nn
xt= xt+ ws(j)*xst(:,j);      % predicted estimate
end
xep=xt;
Ptt=zeros(n,n);
for j=1:nn
Ptt=Ptt+ ws(j)*(xst(:,j)-xep)*(xst(:,j)-xep)';  %prediction of covariance
end
%
Pep=Ptt+QQ;
end  % of i   
%--------------------------------------------------
for i=1:N+1
RMSE(1,i)=sqrt((x(1,i)-xeff(1,i))^2);
end
%
RMSEukf=sum(RMSE)/N

J=1:N+1;
t=J;
figure(1)
plot(t,x(1,1:N+1),'r',t,y(1,1:N+1),'gx-',t,xeff(1,1:N+1),'bo-')
axis([0,N,-15,15]);
grid
legend('True x_t','Observation y_t','Filtered estimate x_{t|t}')
xlabel('Number of steps t')
title('True state, observation and filtered estimate')
%
figure(2)
plot(J,x(2,:),'r-',J,xeff(2,:),'b-','LineWidth',1.5)
title('Fig. 6.6a: Estimaition of Parameter \beta_1'),
xlabel('Number of steps t')
axis([0,N,-2,2]);
legend('True \beta_1=1','Estimate by UKF')
grid
hold on
%
figure(3)
plot(J,x(3,:),'r-',J,xeff(3,:),'b-','LineWidth',1.5)
axis([0,N,-2,2]);
xlabel('Number of steps t')
title('Fig. 6.7a: Estimaition of Parameter \beta_2'),
legend('True \beta_2=0.05','Estimate by UKF')
hold on
grid

figure(4)
plot(J,x(4,:),'r-',J,xeff(4,:),'b-','LineWidth',1.5)
axis([0,N,-2,2]);
xlabel('Number of steps t')
title('Fig. 6.xa: Estimaition of Parameter \beta_3'),
legend('True \beta_3=-0.01','Estimate by UKF')
hold on
grid

figure(5)
plot(J,RMSE,'b-','LineWidth',1.5)
axis([0 N 0 10])
grid
xlabel('Number of steps t')
title('Fig. 6.8a: State estimation error by UKF')
ylabel('E_t')
legend('State estimation error by UKF')
hold on

